<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class CheckSiteMaintenance
{
    public function handle(Request $request, Closure $next): Response
    {
        if (config_value('site_maintenance')) {
            $user = Auth::user();

            if (!$user || !$user->hasRole('super-admin')) {
                abort(403, 'The site is currently under maintenance.');
            }
        }

        return $next($request);
    }
}
